USE [RetailPOS_DB]
GO

/****** Object:  Table [dbo].[Quotation_Join]    Script Date: 08-12-2021 18:54:21 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[Quotation_Join](
	[IPo_ID] [int] IDENTITY(1,1) NOT NULL,
	[InvoiceID] [int] NOT NULL,
	[ProductID] [int] NULL,
	[Barcode] [nchar](100) NULL,
	[MfgDate] [nchar](50) NULL,
	[ExpiryDate] [nchar](50) NULL,
	[SalesRate] [decimal](18, 2) NULL,
	[DiscountPer] [decimal](18, 2) NULL CONSTRAINT [DF_Quotation_Join_DiscountPer]  DEFAULT ((0.00)),
	[Discount] [decimal](18, 2) NULL CONSTRAINT [DF_Quotation_Join_Discount]  DEFAULT ((0.00)),
	[VATPer] [decimal](18, 2) NULL CONSTRAINT [DF_Quotation_Join_VATPer]  DEFAULT ((0.00)),
	[VAT] [decimal](18, 2) NULL CONSTRAINT [DF_Quotation_Join_VAT]  DEFAULT ((0.00)),
	[Qty] [float] NULL CONSTRAINT [DF_Quotation_Join_Qty]  DEFAULT ((1)),
	[TotalAmount] [decimal](18, 2) NULL CONSTRAINT [DF_Quotation_Join_TotalAmount]  DEFAULT ((0.00)),
	[PurchaseRate] [decimal](18, 2) NULL,
	[Margin] [decimal](18, 2) NULL,
	[SN] [nvarchar](250) NULL,
 CONSTRAINT [PK_Quotation_Join] PRIMARY KEY CLUSTERED 
(
	[IPo_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[Quotation_Join]  WITH CHECK ADD  CONSTRAINT [FK_Quotation_Join_Product] FOREIGN KEY([ProductID])
REFERENCES [dbo].[Product] ([PID])
ON UPDATE CASCADE
GO

ALTER TABLE [dbo].[Quotation_Join] CHECK CONSTRAINT [FK_Quotation_Join_Product]
GO

ALTER TABLE [dbo].[Quotation_Join]  WITH CHECK ADD  CONSTRAINT [FK_Quotation_Join_Quotation] FOREIGN KEY([InvoiceID])
REFERENCES [dbo].[Quotation] ([Inv_ID])
ON UPDATE CASCADE
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[Quotation_Join] CHECK CONSTRAINT [FK_Quotation_Join_Quotation]
GO

